<?php

namespace Gambio\Admin\Modules\Customer\App;

use Gambio\Core\Configuration\App\ConfigurationService;

class CustomerValidationService
{
    protected ConfigurationService $configurationService;
    
    public const ACCOUNT_COMPANY = 'configuration/ACCOUNT_COMPANY';
    
    public const ACCOUNT_COMPANY_REQUIRED = 'configuration/ACCOUNT_COMPANY_REQUIRED';
    
    public const ACCOUNT_COMPANY_MIN_LENGTH = 'configuration/ENTRY_COMPANY_MIN_LENGTH';
    
    public const ACCOUNT_NAMES_OPTIONAL = 'configuration/ACCOUNT_NAMES_OPTIONAL';
    
    protected bool $isCompanyEnabled = false;
    
    protected bool $isCompanyRequired = false;
    
    protected int $companyMinLength = 2;
    
    protected int $companyMaxLength = 64;
    
    public bool $tooShort = false;
    
    public bool $tooLong = false;
    
    public function __construct(ConfigurationService $configurationService) {
        $this->configurationService = $configurationService;
        
        $this->setCompanyRequired($this->configurationService->find(self::ACCOUNT_COMPANY_REQUIRED)?->value() === 'true' ?? false);
        
        $this->setCompanyMinLength((int)$this->configurationService->find(self::ACCOUNT_COMPANY_MIN_LENGTH)?->value() ?? 2);
        
        $this->setCompanyEnabled($this->configurationService->find(self::ACCOUNT_COMPANY)?->value() === 'true' ?? false);
    }
    
    public function setCompanyEnabled(bool $isCompanyEnabled): void
    {
        $this->isCompanyEnabled = $isCompanyEnabled;
    }
    
    public function setCompanyRequired(bool $isCompanyRequired): void {
        $this->isCompanyRequired = $isCompanyRequired;
    }
    
    public function setCompanyMinLength(int $companyMinLength): void {
        $this->companyMinLength = $companyMinLength;
    }
    
    public function setCompanyMaxLength(int $companyMaxLength): void {
        $this->companyMaxLength = $companyMaxLength;
    }
    
    public function isCompanyEnabled(): bool
    {
        return $this->isCompanyEnabled;
    }
    
    public function isCompanyRequired(): bool
    {
        return $this->isCompanyRequired;
    }
    
    public function isCompanyNameValid(string $companyName): bool
    {
        $trimmedCompanyName = trim($companyName);
        $companyStrLength = mb_strlen($trimmedCompanyName);
        if($this->isCompanyRequired) {
            if(empty($trimmedCompanyName) || $companyStrLength < $this->companyMinLength) {
                $this->tooShort = true;
                $this->tooLong = false;
                return false;
            } else if($companyStrLength > $this->companyMaxLength) {
                $this->tooLong = true;
                $this->tooShort = false;
                return false;
            }
        } else {
            if(!empty($trimmedCompanyName) && $companyStrLength < $this->companyMinLength) {
                $this->tooShort = true;
                $this->tooLong = false;
                return false;
            }
            if(!empty($trimmedCompanyName) && $companyStrLength > $this->companyMaxLength) {
                $this->tooLong = true;
                $this->tooShort = false;
                return false;
            }
        }
        return true;
    }
}